<?php

include 'koneksi.php';
include 'header1.php';

// **Ambil data hasil perangkingan dari tabel hasil1**
$hasil_perhitungan = query("SELECT * FROM hasil1 ORDER BY nilai DESC");

// **Cek apakah ada nilai yang sama di peringkat teratas**
$nilai_tertinggi = $hasil_perhitungan[0]['nilai'];
$alternatif_tertinggi = array_filter($hasil_perhitungan, function ($row) use ($nilai_tertinggi) {
    return $row['nilai'] == $nilai_tertinggi;
});

?>

<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid mt-5">
            <div class="card-header bg-primary text-white text-center mb-1">
                <h2 class="text-center flex-grow-1 " style="font-size: 28px; font-weight: bold;">
                <i class="fas fa-check"></i> HASIL PERANKINGAN DAN KESIMPULAN</h2>
            </div>

            <br>

            <!-- **Cek jika hasil perhitungan kosong** -->
            <?php if (empty($hasil_perhitungan)) : ?>
                <div class="alert alert-danger text-center">
                    <strong>⚠️ Belum ada hasil perhitungan!</strong> Silakan lakukan proses perhitungan terlebih dahulu di halaman SPK.
                </div>
            <?php else : ?>

                <!-- **Tampilkan hasil perangkingan** -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered text-center w-100" style="font-size: 18px;">
                            <thead class="table-primary">
                                <tr>
                                    <th style="width: 10%;">Peringkat</th>
                                    <th style="width: 50%;">Nama Alternatif</th>
                                    <th style="width: 20%;">Nilai Akhir</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $rank = 1; ?>
                                <?php foreach ($hasil_perhitungan as $row) : ?>
                                    <tr <?= ($row['nilai'] == $nilai_tertinggi) ?>;>
                                        <td style="font-weight: bold;"><?= $rank++; ?></td>
                                        <td><?= htmlspecialchars($row['alternatif']); ?></td>
                                        <td style="font-weight: bold;"><?= number_format($row['nilai'], 6, '.', ''); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <br><br>

                <div class="text-center">
                    <a href="proses1.php" class="btn btn-lg btn-outline-primary">
                        <i class="fas fa-calculator"></i> Lihat Proses Perhitungan
                    </a>
                </div>

                <br><br>

               <!-- **Kesimpulan Hasil Perhitungan** -->
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white text-center">
                        <h4><i class="fas fa-lightbulb"></i> Kesimpulan</h4>
                    </div>
                    <div class="card-body">
                        <?php if (count($alternatif_tertinggi) > 1) : ?>
                            <!-- 🔥 **Jika ada lebih dari satu alternatif dengan nilai tertinggi** -->
                            <p class="text-justify" style="font-size: 18px;">
                                Berdasarkan hasil perhitungan dengan metode <b>Weighted Product</b>, ditemukan bahwa terdapat <b><?= count($alternatif_tertinggi); ?></b> alternatif dengan nilai tertinggi yang sama.
                                Hal ini menunjukkan bahwa beberapa alternatif atau mahasiswa memiliki pengalaman yang serupa dalam memanfaatkan YouTube sebagai media pembelajaran yang efektif.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Berikut adalah daftar alternatif terbaik yang memiliki peringkat tertinggi:
                            </p>

                            <ul style="font-size: 18px;">
                                <?php foreach ($alternatif_tertinggi as $alt) : ?>
                                    <li><b style="color: red;"><?= htmlspecialchars($alt['alternatif']); ?></b> dengan nilai akhir <b style="color: red;"><?= number_format($alt['nilai'], 4, '.', ''); ?></b></li>
                                <?php endforeach; ?>
                            </ul>

                            <p class="text-justify" style="font-size: 18px;">
                                Keberadaan lebih dari satu alternatif dengan skor tertinggi ini mengindikasikan bahwa YouTube memiliki peran yang signifikan dalam meningkatkan efektivitas pembelajaran mahasiswa Teknik Informatika.
                                Beberapa faktor utama yang berkontribusi terhadap efektivitas ini meliputi relevansi konten pembelajaran, kualitas penyampaian materi, kualitas audiovisual, interaktivitas dan engagement, frekuensi penggunaan, serta hambatan akses yang minimal.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Dari hasil ini, dapat disimpulkan bahwa mahasiswa cenderung mendapatkan manfaat maksimal dari sumber pembelajaran berbasis YouTube yang memiliki konten yang sistematis, penyampaian yang jelas, visual yang mendukung pemahaman, serta keterlibatan aktif dalam proses belajar.
                                Selain itu, mahasiswa yang secara rutin menggunakan YouTube sebagai media pembelajaran cenderung memiliki pemahaman yang lebih mendalam dibandingkan mereka yang menggunakannya secara sporadis.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Oleh karena itu, alternatif dengan peringkat tertinggi ini dapat dijadikan sebagai referensi utama bagi mahasiswa dan dosen dalam memilih sumber pembelajaran yang paling efektif.
                                Pengajar dapat mempertimbangkan aspek-aspek yang telah terbukti mendukung efektivitas pembelajaran dan mengintegrasikannya dalam metode pengajaran formal.
                                Sementara itu, mahasiswa dapat menggunakan daftar peringkat ini sebagai acuan dalam memilih kanal YouTube yang sesuai dengan kebutuhan akademik mereka, guna meningkatkan pemahaman konsep-konsep dalam Teknik Informatika secara lebih optimal.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Selain itu, YouTube juga dapat dimanfaatkan oleh dosen sebagai media penyimpanan arsip perkuliahan atau rekaman sesi pembelajaran yang telah berlangsung.
                                Hal ini memberikan fleksibilitas yang lebih tinggi dalam proses belajar-mengajar, di mana mahasiswa dapat mengakses materi kapan saja dan di mana saja.
                                Dengan adanya rekaman perkuliahan yang terdokumentasi dengan baik, mahasiswa memiliki kesempatan untuk mengulang materi yang belum dipahami secara mendalam tanpa batasan waktu.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Fleksibilitas ini menjadikan YouTube sebagai platform pembelajaran yang adaptif, memungkinkan mahasiswa untuk belajar sesuai dengan kecepatan dan gaya belajar masing-masing.
                                Selain itu, dosen juga dapat menggunakan YouTube sebagai media untuk menyusun materi pembelajaran yang lebih terstruktur dan dapat digunakan dalam jangka panjang sebagai referensi akademik yang bernilai.
                            </p>
                            <p class="text-justify" style="font-size: 18px;">
                                        Lebih lanjut, YouTube tidak hanya berfungsi sebagai sumber pembelajaran bagi mahasiswa, tetapi juga sebagai alat bantu bagi dosen dalam menyusun strategi pengajaran yang lebih efektif.
                                        Rekaman materi kuliah yang diunggah ke YouTube dapat dijadikan sebagai arsip pembelajaran, yang memungkinkan mahasiswa untuk mengakses ulang materi yang telah diberikan kapan saja sesuai dengan kebutuhan akademik mereka.
                                    </p>

                                    <p class="text-justify" style="font-size: 18px;">
                                        Dengan adanya dokumentasi pembelajaran dalam format video, dosen dapat melakukan analisis terhadap metode pengajaran yang telah diterapkan serta mengevaluasi efektivitasnya.
                                        Dengan demikian, YouTube tidak hanya berperan dalam menyediakan aksesibilitas materi yang lebih luas bagi mahasiswa, tetapi juga mendukung peningkatan kualitas pengajaran di lingkungan akademik secara lebih berkelanjutan.
                                    </p>

                        <?php else : ?>
                            <!-- ✅ **Jika hanya ada satu alternatif dengan nilai tertinggi** -->
                            <p class="text-justify" style="font-size: 18px;">
                                Berdasarkan hasil perhitungan dengan metode <b>Weighted Product</b>, alternatif dengan peringkat tertinggi adalah
                                <b style="color: red;"><?= htmlspecialchars($hasil_perhitungan[0]['alternatif']); ?></b>, dengan nilai akhir
                                <b style="color: red;"><?= number_format($hasil_perhitungan[0]['nilai'], 6, '.', ''); ?></b>.
                                Alternatif ini memiliki keunggulan dibandingkan alternatif lainnya dalam berbagai aspek evaluasi pembelajaran.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Berdasarkan analisis hasil perangkingan, aspek utama yang berkontribusi terhadap efektivitas alternatif terbaik ini adalah relevansi konten pembelajaran, kualitas penyampaian materi, kualitas audiovisual, interaktivitas dan engagement, serta frekuensi penggunaan.
                                Alternatif ini memberikan pengalaman belajar yang lebih efektif bagi mahasiswa Teknik Informatika dibandingkan sumber pembelajaran lainnya.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Dengan demikian, alternatif ini dapat dijadikan sebagai rekomendasi utama dalam penilaian efektivitas pembelajaran berbasis YouTube. Hasil ini dapat digunakan sebagai acuan bagi mahasiswa dan pengajar dalam memilih sumber pembelajaran yang optimal, guna meningkatkan pemahaman konsep-konsep dalam bidang Teknik Informatika secara lebih efektif.
                            </p>
                            <p class="text-justify" style="font-size: 18px;">
                                Selain itu, YouTube juga dapat dimanfaatkan oleh dosen sebagai media penyimpanan arsip perkuliahan atau rekaman sesi pembelajaran yang telah berlangsung.
                                Hal ini memberikan fleksibilitas yang lebih tinggi dalam proses belajar-mengajar, di mana mahasiswa dapat mengakses materi kapan saja dan di mana saja.
                                Dengan adanya rekaman perkuliahan yang terdokumentasi dengan baik, mahasiswa memiliki kesempatan untuk mengulang materi yang belum dipahami secara mendalam tanpa batasan waktu.
                            </p>
                            <p class="text-justify" style="font-size: 18px;">
                                Lebih lanjut, YouTube tidak hanya berfungsi sebagai sumber pembelajaran bagi mahasiswa, tetapi juga sebagai alat bantu bagi dosen dalam menyusun strategi pengajaran yang lebih efektif.
                                Rekaman materi kuliah yang diunggah ke YouTube dapat dijadikan sebagai arsip pembelajaran, yang memungkinkan mahasiswa untuk mengakses ulang materi yang telah diberikan kapan saja sesuai dengan kebutuhan akademik mereka.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Selain itu, dengan adanya dokumentasi pembelajaran dalam format video, dosen dapat melakukan analisis terhadap metode pengajaran yang telah diterapkan serta mengevaluasi efektivitasnya.
                                Dengan demikian, YouTube tidak hanya berperan dalam menyediakan aksesibilitas materi yang lebih luas bagi mahasiswa, tetapi juga mendukung peningkatan kualitas pengajaran di lingkungan akademik secara lebih berkelanjutan.
                            </p>


                        <?php endif; ?>
                    </div>
             

                        <br>

                <!-- **Form Export ke PDF** -->
                <div class="text-center">
                    <p style="font-size: 18px;">⬇ *Unduh hasil dalam format PDF*</p>
                    <form action="reportpdf1.php" method="post">
                        <button type="submit" class="btn btn-lg btn-danger" name="submit">
                            <i class="fas fa-file-pdf"></i> Unduh PDF
                        </button>
                        <br><br>
                    </form>
                    
                </div>

            <?php endif; ?>
            </div>
        </div>
    </main>
</div>
